/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class NetherbornPhalanxEffect
extends OneShotEffect {
    NetherbornPhalanxEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each opponent loses 1 life for each creature they control";
    }

    private NetherbornPhalanxEffect(NetherbornPhalanxEffect effect) {
        super((OneShotEffect)effect);
    }

    public NetherbornPhalanxEffect copy() {
        return new NetherbornPhalanxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            for (UUID playerId : game.getOpponents(source.getControllerId())) {
                Player opponent;
                int count = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, playerId, game).size();
                if (count <= 0 || (opponent = game.getPlayer(playerId)) == null) continue;
                opponent.loseLife(count, game, source, false);
            }
            return true;
        }
        return false;
    }
}

