/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.NettlingNuisancePirateToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NettlingNuisanceEffect
extends OneShotEffect {
    NettlingNuisanceEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "that player creates a 4/2 red Pirate creature token with \"This creature can't block.\" The token is goaded for the rest of the game. <i>(It attacks each combat if able and attacks a player other than you if able.)</i>";
    }

    private NettlingNuisanceEffect(NettlingNuisanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        NettlingNuisancePirateToken token = new NettlingNuisancePirateToken();
        token.putOntoBattlefield(1, game, source, player.getId());
        token.getLastAddedTokenIds().forEach(id -> game.addEffect(new GoadTargetEffect().setDuration(Duration.EndOfGame).setTargetPointer((TargetPointer)new FixedTarget(id, game)), source));
        return true;
    }

    public NettlingNuisanceEffect copy() {
        return new NettlingNuisanceEffect(this);
    }
}

