/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class NeverendingTormentEffect
extends OneShotEffect {
    NeverendingTormentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search target player's library for X cards, where X is the number of cards in your hand, and exile them. Then that player shuffles";
    }

    private NeverendingTormentEffect(NeverendingTormentEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player you = game.getPlayer(source.getControllerId());
        if (targetPlayer != null && you != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(you.getHand().size(), new FilterCard());
            you.searchLibrary(target, source, game, targetPlayer.getId());
            for (UUID cardId : target.getTargets()) {
                Card targetCard = game.getCard(cardId);
                if (targetCard == null) continue;
                applied |= you.moveCardToExileWithInfo(targetCard, null, null, source, game, Zone.LIBRARY, true);
            }
            targetPlayer.shuffleLibrary(source, game);
        }
        return applied;
    }

    public NeverendingTormentEffect copy() {
        return new NeverendingTormentEffect(this);
    }
}

