/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.n.ChangeCreatureTypeTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NewBloodEffect
extends OneShotEffect {
    NewBloodEffect() {
        super(Outcome.Benefit);
        this.staticText = "Gain control of target creature. Change the text of that creature by replacing all instances of one creature type with Vampire";
    }

    private NewBloodEffect(NewBloodEffect effect) {
        super((OneShotEffect)effect);
    }

    public NewBloodEffect copy() {
        return new NewBloodEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            Object effect = new GainControlTargetEffect(Duration.Custom, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            effect = new ChangeCreatureTypeTargetEffect(null, SubType.VAMPIRE, Duration.Custom);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

