/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class NewFrontiersEffect
extends OneShotEffect {
    NewFrontiersEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player may search their library for up to X basic land cards and put them onto the battlefield tapped. Then each player who searched their library this way shuffles";
    }

    private NewFrontiersEffect(NewFrontiersEffect effect) {
        super((OneShotEffect)effect);
    }

    public NewFrontiersEffect copy() {
        return new NewFrontiersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetCardInLibrary target;
                Player player = game.getPlayer(playerId);
                if (player == null || !player.chooseUse(this.outcome, "Search your library for up to " + amount + " basic lands?", source, game) || !player.searchLibrary(target = new TargetCardInLibrary(0, amount, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), source, game)) continue;
                player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
                player.shuffleLibrary(source, game);
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

