/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.MustBeBlockedByAtLeastOneTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NeyithOfTheDireHuntEffect
extends OneShotEffect {
    NeyithOfTheDireHuntEffect() {
        super(Outcome.Benefit);
        this.staticText = "double target creature's power until end of turn. That creature must be blocked this combat if able";
    }

    private NeyithOfTheDireHuntEffect(NeyithOfTheDireHuntEffect effect) {
        super((OneShotEffect)effect);
    }

    public NeyithOfTheDireHuntEffect copy() {
        return new NeyithOfTheDireHuntEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        game.addEffect((ContinuousEffect)new BoostTargetEffect(power, 0, Duration.EndOfTurn), source);
        game.addEffect((ContinuousEffect)new MustBeBlockedByAtLeastOneTargetEffect(Duration.EndOfCombat), source);
        return true;
    }
}

