/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NiambiEsteemedSpeakerEffect
extends OneShotEffect {
    NiambiEsteemedSpeakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "If you do, you gain life equal to that creature's mana value.";
    }

    private NiambiEsteemedSpeakerEffect(NiambiEsteemedSpeakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public NiambiEsteemedSpeakerEffect copy() {
        return new NiambiEsteemedSpeakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        return permanent.getManaValue() > 0 && player.gainLife(permanent.getManaValue(), game, source) > 0;
    }
}

