/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class NicolBolasDragonGodMinus8Effect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreatureOrPlaneswalkerPermanent();

    NicolBolasDragonGodMinus8Effect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent who doesn't control a legendary creature or planeswalker loses the game.";
    }

    private NicolBolasDragonGodMinus8Effect(NicolBolasDragonGodMinus8Effect effect) {
        super((OneShotEffect)effect);
    }

    public NicolBolasDragonGodMinus8Effect copy() {
        return new NicolBolasDragonGodMinus8Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.hasOpponent(source.getControllerId(), game) || !game.getBattlefield().getAllActivePermanents(filter, opponentId, game).isEmpty()) continue;
            opponent.lost(game);
        }
        return true;
    }

    static {
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
    }
}

