/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class NightTerrorsEffect
extends OneShotEffect {
    NightTerrorsEffect() {
        super(Outcome.Exile);
        this.staticText = "Target player reveals their hand. You choose a nonland card from it. Exile that card";
    }

    private NightTerrorsEffect(NightTerrorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public NightTerrorsEffect copy() {
        return new NightTerrorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (player == null || targetPlayer == null) {
            return false;
        }
        targetPlayer.revealCards(source, targetPlayer.getHand(), game);
        TargetCard target = new TargetCard(Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        if (!player.choose(Outcome.Exile, targetPlayer.getHand(), target, source, game)) {
            return true;
        }
        Card card = targetPlayer.getHand().get(target.getFirstTarget(), game);
        return card != null && player.moveCards(card, Zone.EXILED, source, game);
    }
}

