/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NightmareShepherdEffect
extends OneShotEffect {
    NightmareShepherdEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it. If you do, create a token that's a copy of that creature, except it's 1/1 and it's a Nightmare in addition to its other types.";
    }

    private NightmareShepherdEffect(NightmareShepherdEffect effect) {
        super((OneShotEffect)effect);
    }

    public NightmareShepherdEffect copy() {
        return new NightmareShepherdEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1, false, false, null, 1, 1, false);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), card.getZoneChangeCounter(game) + 1));
        effect.withAdditionalSubType(SubType.NIGHTMARE);
        player.moveCards(card, Zone.EXILED, source, game);
        effect.apply(game, source);
        return true;
    }
}

