/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.combat.CantAttackYouUnlessPayAllEffect;
import mage.constants.Duration;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NilsDisciplineEnforcerEffect
extends CantAttackYouUnlessPayAllEffect {
    NilsDisciplineEnforcerEffect() {
        super(Duration.WhileOnBattlefield, (Cost)new ManaCostsImpl("{X}"), CantAttackYouUnlessPayAllEffect.Scope.YOU_AND_CONTROLLED_PLANESWALKERS);
        this.staticText = "Each creature with one or more counters on it can't attack you or planeswalkers you control unless its controller pays {X}, where X is the number of counters on that creature.";
    }

    private NilsDisciplineEnforcerEffect(NilsDisciplineEnforcerEffect effect) {
        super((CantAttackYouUnlessPayAllEffect)effect);
    }

    public ManaCosts getManaCostToPay(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent == null) {
            return null;
        }
        int count = permanent.getCounters(game).keySet().stream().mapToInt(arg_0 -> ((Counters)permanent.getCounters(game)).getCount(arg_0)).sum();
        if (count < 1) {
            return null;
        }
        return new ManaCostsImpl("{" + count + '}');
    }

    public NilsDisciplineEnforcerEffect copy() {
        return new NilsDisciplineEnforcerEffect(this);
    }
}

