/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;
import mage.util.ManaUtil;

class NimDeathmantleEffect
extends OneShotEffect {
    private final Cost cost = ManaUtil.createManaCost((int)4, (boolean)false);

    public NimDeathmantleEffect() {
        super(Outcome.Benefit);
    }

    private NimDeathmantleEffect(NimDeathmantleEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (controller != null && equipment != null) {
            if (controller.chooseUse(Outcome.Benefit, equipment.getName() + " - Pay " + this.cost.getText() + '?', source, game)) {
                Permanent permanent;
                Card card;
                UUID target;
                this.cost.clearPaid();
                if (this.cost.pay(source, game, source, source.getControllerId(), false) && (target = this.getTargetPointer().getFirst(game, source)) != null && (card = game.getCard(target)) != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD && controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                    permanent.addAttachment(equipment.getId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    public NimDeathmantleEffect copy() {
        return new NimDeathmantleEffect(this);
    }
}

