/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NineLivesPreventionEffect
extends PreventionEffectImpl {
    NineLivesPreventionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If a source would deal damage to you, prevent that damage and put an incarnation counter on {this}";
    }

    private NineLivesPreventionEffect(NineLivesPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public NineLivesPreventionEffect copy() {
        return new NineLivesPreventionEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventDamageEvent preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage());
        if (!game.replaceEvent((GameEvent)preventEvent)) {
            Permanent nineLives;
            int damage = event.getAmount();
            Player player = game.getPlayer(source.getControllerId());
            if (player != null && (nineLives = source.getSourcePermanentIfItStillExists(game)) != null) {
                nineLives.addCounters(CounterType.INCARNATION.createInstance(1), source.getControllerId(), source, game);
            }
            event.setAmount(0);
            game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game)) {
            return event.getTargetId().equals(source.getControllerId());
        }
        return false;
    }
}

