/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.ManaValueLessThanControlledLandCountPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class NissaOfShadowedBoughsPutCardEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value less than or equal to the number of lands you control");

    NissaOfShadowedBoughsPutCardEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may put a creature card with mana value less than or equal to the number of lands you control onto the battlefield from your hand or graveyard with two +1/+1 counters on it";
    }

    private NissaOfShadowedBoughsPutCardEffect(NissaOfShadowedBoughsPutCardEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissaOfShadowedBoughsPutCardEffect copy() {
        return new NissaOfShadowedBoughsPutCardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)controller.getHand().getCards((FilterCard)filter, source.getControllerId(), source, game));
        cards.addAllCards((Collection)controller.getGraveyard().getCards((FilterCard)filter, source.getControllerId(), source, game));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(0, 1, Zone.ALL, (FilterCard)filter);
        target.withNotTarget(true);
        controller.choose(this.outcome, (Cards)cards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            Counters counters = new Counters(new Counter[0]);
            counters.addCounter(CounterType.P1P1.createInstance(2));
            game.setEnterWithCounters(card.getId(), counters);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)ManaValueLessThanControlledLandCountPredicate.instance);
    }
}

