/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class NissaStewardOfElementsEffect
extends OneShotEffect {
    NissaStewardOfElementsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "look at the top card of your library. If it's a land card or a creature card with mana value less than or equal to the number of loyalty counters on {this}, you may put that card onto the battlefield";
    }

    private NissaStewardOfElementsEffect(NissaStewardOfElementsEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissaStewardOfElementsEffect copy() {
        return new NissaStewardOfElementsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int count = 1 + new CountersSourceCount(CounterType.LOYALTY).calculate(game, source, (Effect)this);
        FilterPermanentCard filter = new FilterPermanentCard();
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.LAND.getPredicate()));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, count));
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            controller.lookAtCards(source, null, (Cards)new CardsImpl(card), game);
            if (filter.match(card, game) && controller.chooseUse(this.outcome, "Put " + card.getName() + " onto the battlefield?", source, game)) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
        }
        return true;
    }
}

