/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.cards.Card;
import mage.cards.n.NissaWorldwakerToken;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class NissaWorldwakerSearchEffect
extends OneShotEffect {
    NissaWorldwakerSearchEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Search your library for any number of basic land cards, put them onto the battlefield, then shuffle. Those lands become 4/4 Elemental creatures with trample. They're still lands";
    }

    private NissaWorldwakerSearchEffect(NissaWorldwakerSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public NissaWorldwakerSearchEffect copy() {
        return new NissaWorldwakerSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        if (controller.searchLibrary(target, source, game) && !target.getTargets().isEmpty()) {
            for (UUID cardId : target.getTargets()) {
                Permanent land;
                Card card = controller.getLibrary().getCard(cardId, game);
                if (card == null || !controller.moveCards(card, Zone.BATTLEFIELD, source, game) || (land = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) == null) continue;
                BecomesCreatureTargetEffect effect = new BecomesCreatureTargetEffect((Token)new NissaWorldwakerToken(), false, true, Duration.Custom);
                effect.setTargetPointer((TargetPointer)new FixedTarget(land, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

