/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NissasChosenEffect
extends ReplacementEffectImpl {
    NissasChosenEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If {this} would die, put it on the bottom of its owner's library instead";
    }

    private NissasChosenEffect(NissasChosenEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public NissasChosenEffect copy() {
        return new NissasChosenEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent;
        return event.getTargetId().equals(source.getSourceId()) && (zEvent = (ZoneChangeEvent)event).isDiesEvent();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null && controller != null) {
            controller.moveCardToLibraryWithInfo((Card)permanent, source, game, Zone.BATTLEFIELD, false, true);
            return true;
        }
        return false;
    }
}

