/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Objects;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class NivMizzetRebornTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("a card of each color pair");

    NivMizzetRebornTarget() {
        super(0, 10, filter);
    }

    private NivMizzetRebornTarget(NivMizzetRebornTarget target) {
        super((TargetCardInLibrary)target);
    }

    public NivMizzetRebornTarget copy() {
        return new NivMizzetRebornTarget(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) return true;
        if (!this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).map(c -> c.getColor(game)).noneMatch(arg_0 -> ((ObjectColor)card.getColor(game)).equals(arg_0))) return false;
        return true;
    }

    static {
        filter.add((Predicate)NivMizzetRebornPredicate.instance);
    }

    private static enum NivMizzetRebornPredicate implements Predicate<Card>
    {
        instance;


        public boolean apply(Card input, Game game) {
            return input.getColor(game).getColorCount() == 2;
        }
    }
}

