/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class NomadMythmakerEffect
extends OneShotEffect {
    NomadMythmakerEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Put target Aura card from a graveyard onto the battlefield under your control attached to a creature you control.";
    }

    private NomadMythmakerEffect(NomadMythmakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public NomadMythmakerEffect copy() {
        return new NomadMythmakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        Card aura = game.getCard(source.getFirstTarget());
        if (controller == null || aura == null) {
            return false;
        }
        FilterControlledCreaturePermanent FILTER = new FilterControlledCreaturePermanent("Choose a creature you control");
        TargetControlledPermanent target = new TargetControlledPermanent((FilterControlledPermanent)FILTER);
        target.withNotTarget(true);
        if (controller.choose(Outcome.PutCardInPlay, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null && !permanent.cantBeAttachedBy((MageObject)aura, source, game, false)) {
            game.getState().setValue("attachTo:" + aura.getId(), (Object)permanent);
            controller.moveCards(aura, Zone.BATTLEFIELD, source, game);
            return permanent.addAttachment(aura.getId(), source, game);
        }
        return false;
    }
}

