/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NornsInquisitorTriggeredAbility
extends TriggeredAbilityImpl {
    public NornsInquisitorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), false);
    }

    private NornsInquisitorTriggeredAbility(NornsInquisitorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NornsInquisitorTriggeredAbility copy() {
        return new NornsInquisitorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRANSFORMED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null || !StaticFilters.FILTER_CONTROLLED_PERMANENT.match(permanent, this.getControllerId(), (Ability)this, game) || !permanent.hasSubtype(SubType.PHYREXIAN, game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        return true;
    }

    public String getRule() {
        return "Whenever a permanent you control transforms into a Phyrexian, put a +1/+1 counter on it.";
    }
}

