/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.constants.TargetController;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.target.Target;

enum NotOfThisWorldCondition implements Condition
{
    instance;

    private static final FilterCreaturePermanent filter;

    public boolean apply(Game game, Ability source) {
        StackObject sourceSpell = game.getStack().getStackObject(source.getSourceId());
        if (sourceSpell == null || !sourceSpell.getStackAbility().getTargets().isChosen(game)) {
            return false;
        }
        StackObject objectToCounter = game.getStack().getStackObject(sourceSpell.getStackAbility().getTargets().getFirstTarget());
        if (objectToCounter == null) {
            return false;
        }
        return objectToCounter.getStackAbility().getModes().values().stream().map(Mode::getTargets).flatMap(Collection::stream).filter(target -> !target.isNotTarget()).map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).anyMatch(permanent -> permanent != null && filter.match(permanent, sourceSpell.getControllerId(), source, game));
    }

    public String toString() {
        return "it targets a spell or ability that targets a creature you control with power 7 or greater";
    }

    static {
        filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 6));
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

