/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddPoisonCounterTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NoxiousAssaultDelayedTriggerAbility
extends DelayedTriggeredAbility {
    NoxiousAssaultDelayedTriggerAbility() {
        super((Effect)new AddPoisonCounterTargetEffect(1), Duration.EndOfTurn, false, false);
    }

    private NoxiousAssaultDelayedTriggerAbility(NoxiousAssaultDelayedTriggerAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATURE_BLOCKS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId()));
        return true;
    }

    public NoxiousAssaultDelayedTriggerAbility copy() {
        return new NoxiousAssaultDelayedTriggerAbility(this);
    }

    public String getRule() {
        return "Whenever a creature blocks this turn, its controller gets a poison counter.";
    }
}

