/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class NullChamberReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    NullChamberReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.AIDontUseIt);
        this.staticText = "The named cards can't be played";
    }

    private NullChamberReplacementEffect(NullChamberReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public NullChamberReplacementEffect copy() {
        return new NullChamberReplacementEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast a spell with that name (" + mageObject.getName() + " in play).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        if (object != null) {
            return object.getName().equals(game.getState().getValue(source.getSourceId().toString() + "CONTROLLER_NAMED_CARD")) || object.getName().equals(game.getState().getValue(source.getSourceId().toString() + "OPPONENT_NAMED_CARD"));
        }
        return false;
    }
}

