/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class NulltreadGargantuanEffect
extends OneShotEffect {
    NulltreadGargantuanEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "put a creature you control on top of its owner's library";
    }

    private NulltreadGargantuanEffect(NulltreadGargantuanEffect effect) {
        super((OneShotEffect)effect);
    }

    public NulltreadGargantuanEffect copy() {
        return new NulltreadGargantuanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && player.putCardsOnTopOfLibrary((Card)permanent, game, source, false);
    }
}

