/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class NyleaKeenEyedEffect
extends OneShotEffect {
    NyleaKeenEyedEffect() {
        super(Outcome.Detriment);
        this.staticText = "reveal the top card of your library. If it's a creature card, put it into your hand. Otherwise, you may put it into your graveyard";
    }

    private NyleaKeenEyedEffect(NyleaKeenEyedEffect effect) {
        super((OneShotEffect)effect);
    }

    public NyleaKeenEyedEffect copy() {
        return new NyleaKeenEyedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.isCreature(game)) {
            return player.moveCards(card, Zone.HAND, source, game);
        }
        if (!player.chooseUse(Outcome.Detriment, "Put " + card.getName() + " into your graveyard?", source, game)) {
            return true;
        }
        return player.moveCards(card, Zone.GRAVEYARD, source, game);
    }
}

