/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class OathOfDruidsEffect
extends OneShotEffect {
    OathOfDruidsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "that player chooses target player who controls more creatures than they do and is their opponent. The first player may reveal cards from the top of their library until they reveal a creature card. If the first player does, that player puts that card onto the battlefield and all other cards revealed this way into their graveyard";
    }

    private OathOfDruidsEffect(OathOfDruidsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(game.getActivePlayerId());
        if (controller == null) {
            return false;
        }
        CardsImpl revealed = new CardsImpl();
        Card selectedCard = null;
        CardsImpl notSelectedCards = new CardsImpl();
        if (!controller.chooseUse(Outcome.Benefit, "Use this ability?", source, game)) {
            return true;
        }
        for (Card card : controller.getLibrary().getCards(game)) {
            revealed.add(card);
            if (card.isCreature(game)) {
                selectedCard = card;
                break;
            }
            notSelectedCards.add(card);
        }
        controller.revealCards(source, (Cards)revealed, game);
        if (selectedCard != null) {
            controller.moveCards(selectedCard, Zone.BATTLEFIELD, source, game);
        }
        controller.moveCards((Cards)notSelectedCards, Zone.GRAVEYARD, source, game);
        return true;
    }

    public OathOfDruidsEffect copy() {
        return new OathOfDruidsEffect(this);
    }
}

