/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OathOfKayaTriggeredAbility
extends TriggeredAbilityImpl {
    public OathOfKayaTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2), false);
        this.addEffect((Effect)new GainLifeEffect(2));
    }

    private OathOfKayaTriggeredAbility(OathOfKayaTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public OathOfKayaTriggeredAbility copy() {
        return new OathOfKayaTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player you = game.getPlayer(this.getControllerId());
        if (you == null) {
            return false;
        }
        if (game.getCombat().isPlaneswalkerAttacked(you.getId(), game)) {
            for (UUID attacker : game.getCombat().getAttackers()) {
                Permanent attackingPermanent = game.getPermanent(attacker);
                if (attackingPermanent == null || !attackingPermanent.isCreature(game)) continue;
                this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(attackingPermanent.getControllerId(), game));
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent attacks a planeswalker you control with one or more creatures, {this} deals 2 damage to that player and you gain 2 life.";
    }
}

