/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;

class OathOfLiegesPredicate
implements ObjectSourcePlayerPredicate<Player> {
    OathOfLiegesPredicate() {
    }

    public boolean apply(ObjectSourcePlayer<Player> input, Game game) {
        int countActivePlayer;
        Player targetPlayer = (Player)input.getObject();
        UUID activePlayerId = game.getActivePlayerId();
        if (targetPlayer == null || activePlayerId == null) {
            return false;
        }
        if (!targetPlayer.hasOpponent(activePlayerId, game)) {
            return false;
        }
        int countTargetPlayer = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, targetPlayer.getId(), game);
        return countTargetPlayer > (countActivePlayer = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, activePlayerId, game));
    }

    public String toString() {
        return "player who controls more lands than they do and is their opponent";
    }
}

