/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class OathOfLilianaWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    public OathOfLilianaWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).getToZone() == Zone.BATTLEFIELD && zEvent.getTarget().isPlaneswalker(game)) {
            this.players.add(zEvent.getTarget().getControllerId());
        }
    }

    public void reset() {
        this.players.clear();
    }

    public boolean enteredPlaneswalkerForPlayer(UUID playerId) {
        return this.players.contains(playerId);
    }
}

