/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.dynamicvalue.common.SavedLifeLossValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoUnlessControllerPaysEffect;
import mage.abilities.effects.common.SacrificeControllerEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;

class OathOfLimDulEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("controlled permanent other than {this} to sacrifice");

    OathOfLimDulEffect() {
        super(Outcome.Detriment);
        this.staticText = "for each 1 life you lost, sacrifice a permanent other than {this} unless you discard a card";
    }

    private OathOfLimDulEffect(OathOfLimDulEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amountDamage = SavedLifeLossValue.MANY.calculate(game, source, (Effect)this);
        Player controller = game.getPlayer(source.getControllerId());
        if (amountDamage <= 0 || controller == null) {
            return false;
        }
        boolean didSomething = false;
        for (int i = 0; i < amountDamage; ++i) {
            didSomething |= new DoUnlessControllerPaysEffect((Effect)new SacrificeControllerEffect((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_PERMANENT, 1, ""), (Cost)new DiscardCardCost()).apply(game, source);
        }
        return didSomething;
    }

    public OathOfLimDulEffect copy() {
        return new OathOfLimDulEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

