/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class OathOfScholarsEffect
extends OneShotEffect {
    OathOfScholarsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "that player chooses target player who has more cards in hand than they do and is their opponent. The first player may discard their hand and draw three cards";
    }

    private OathOfScholarsEffect(OathOfScholarsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        Player firstPlayer = game.getPlayer(game.getActivePlayerId());
        if (sourceObject == null || firstPlayer == null) {
            return false;
        }
        if (firstPlayer.chooseUse(Outcome.AIDontUseIt, "Discard your hand and draw 3 cards?", source, game)) {
            firstPlayer.discard(firstPlayer.getHand().size(), true, false, source, game);
            firstPlayer.drawCards(3, source, game);
            return true;
        }
        return false;
    }

    public OathOfScholarsEffect copy() {
        return new OathOfScholarsEffect(this);
    }
}

