/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.players.Player;
import mage.util.CardUtil;

class OccultEpiphanyEffect
extends OneShotEffect {
    OccultEpiphanyEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw X cards, then discard X cards. Create a 1/1 white Spirit creature token with flying for each card type among cards discarded this way";
    }

    private OccultEpiphanyEffect(OccultEpiphanyEffect effect) {
        super((OneShotEffect)effect);
    }

    public OccultEpiphanyEffect copy() {
        return new OccultEpiphanyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player == null || xValue < 1) {
            return false;
        }
        player.drawCards(xValue, source, game);
        int cardTypes = player.discard(xValue, false, false, source, game).getCards(game).stream().map(card -> card.getCardType(game)).flatMap(Collection::stream).distinct().mapToInt(x -> 1).sum();
        if (cardTypes > 0) {
            new SpiritWhiteToken().putOntoBattlefield(cardTypes, game, source);
        }
        return true;
    }
}

