/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.Step;

class OccupationRestrictionEffect
extends RestrictionEffect {
    OccupationRestrictionEffect() {
        super(Duration.Custom);
        this.staticText = "";
    }

    private OccupationRestrictionEffect(OccupationRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.addInfo("Can't attack or block and its activated abilities can't be activated." + this.getId(), "", game);
        }
    }

    public boolean isInactive(Ability source, Game game) {
        if (game.getPhase().getStep().getType() == PhaseStep.UNTAP && game.getStep().getStepPart() == Step.StepPart.PRE && (game.isActivePlayer(source.getControllerId()) || game.getPlayer(source.getControllerId()).hasReachedNextTurnAfterLeaving())) {
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                permanent.addInfo("Can't attack or block and its activated abilities can't be activated." + this.getId(), "", game);
            }
            return true;
        }
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(permanent.getId());
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public OccupationRestrictionEffect copy() {
        return new OccupationRestrictionEffect(this);
    }
}

