/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.SkulkAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;

class OdricLunarchMarshalEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filterFirstStrike = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterFlying = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterDeathtouch = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterDoubleStrike = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterHaste = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterHexproof = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterIndestructible = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterLifelink = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterMenace = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterReach = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterSkulk = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterTrample = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterVigilance = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterCreatures = new FilterControlledCreaturePermanent();

    OdricLunarchMarshalEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "creatures you control gain first strike until end of turn if a creature you control has first strike. The same is true for flying, deathtouch, double strike, haste, hexproof, indestructible, lifelink, menace, reach, skulk, trample, and vigilance.";
    }

    private OdricLunarchMarshalEffect(OdricLunarchMarshalEffect effect) {
        super((OneShotEffect)effect);
    }

    public OdricLunarchMarshalEffect copy() {
        return new OdricLunarchMarshalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getBattlefield().containsControlled((FilterPermanent)filterFirstStrike, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterFlying, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterDeathtouch, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterDoubleStrike, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterHaste, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterHexproof, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)HexproofAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterIndestructible, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterLifelink, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterMenace, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)new MenaceAbility(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterReach, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)ReachAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterSkulk, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)new SkulkAbility(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterTrample, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filterVigilance, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        return true;
    }

    static {
        filterFirstStrike.add((Predicate)new AbilityPredicate(FirstStrikeAbility.class));
        filterFlying.add((Predicate)new AbilityPredicate(FlyingAbility.class));
        filterDeathtouch.add((Predicate)new AbilityPredicate(DeathtouchAbility.class));
        filterDoubleStrike.add((Predicate)new AbilityPredicate(DoubleStrikeAbility.class));
        filterHaste.add((Predicate)new AbilityPredicate(HasteAbility.class));
        filterHexproof.add((Predicate)new AbilityPredicate(HexproofBaseAbility.class));
        filterIndestructible.add((Predicate)new AbilityPredicate(IndestructibleAbility.class));
        filterLifelink.add((Predicate)new AbilityPredicate(LifelinkAbility.class));
        filterMenace.add((Predicate)new AbilityPredicate(MenaceAbility.class));
        filterReach.add((Predicate)new AbilityPredicate(ReachAbility.class));
        filterSkulk.add((Predicate)new AbilityPredicate(SkulkAbility.class));
        filterTrample.add((Predicate)new AbilityPredicate(TrampleAbility.class));
        filterVigilance.add((Predicate)new AbilityPredicate(VigilanceAbility.class));
    }
}

