/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class OildeepGearhulkEffect
extends OneShotEffect {
    public OildeepGearhulkEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at target player's hand. You may choose a card from it. If you do, that player discards that card, then draws a card";
    }

    public OildeepGearhulkEffect(OildeepGearhulkEffect effect) {
        super((OneShotEffect)effect);
    }

    public OildeepGearhulkEffect copy() {
        return new OildeepGearhulkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (controller == null || targetPlayer == null) {
            return false;
        }
        controller.lookAtCards(targetPlayer.getName() + " Hand", targetPlayer.getHand(), game);
        TargetCard chosenCard = new TargetCard(0, 1, Zone.HAND, new FilterCard("card to discard"));
        if (!controller.choose(Outcome.Discard, targetPlayer.getHand(), chosenCard, source, game)) {
            return false;
        }
        Card card = game.getCard(chosenCard.getFirstTarget());
        if (card == null) {
            return false;
        }
        targetPlayer.discard(card, false, source, game);
        targetPlayer.drawCards(1, source, game);
        return true;
    }
}

