/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OjerAxonilDeepestMightReplacementEffect
extends ReplacementEffectImpl {
    OjerAxonilDeepestMightReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a red source you control would deal an amount of noncombat damage less than {this}'s power to an opponent, that source deals damage equal to {this}'s power instead.";
    }

    private OjerAxonilDeepestMightReplacementEffect(OjerAxonilDeepestMightReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public OjerAxonilDeepestMightReplacementEffect copy() {
        return new OjerAxonilDeepestMightReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent ojer = source.getSourcePermanentIfItStillExists(game);
        if (ojer != null && ojer.getPower().getValue() > 0) {
            event.setAmount(ojer.getPower().getValue());
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject sourceObject;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.hasOpponent(event.getTargetId(), game)) {
            return false;
        }
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (sourcePermanent == null) {
            sourceObject = game.getObject(event.getSourceId());
            if (sourceObject == null || !(sourceObject instanceof Controllable) || !((Controllable)sourceObject).isControlledBy(controller.getId())) {
                return false;
            }
        } else {
            if (!sourcePermanent.isControlledBy(controller.getId())) {
                return false;
            }
            sourceObject = sourcePermanent;
        }
        Permanent ojer = source.getSourcePermanentIfItStillExists(game);
        DamageEvent dmgEvent = (DamageEvent)event;
        return sourceObject != null && ojer != null && dmgEvent != null && sourceObject.getColor(game).isRed() && !dmgEvent.isCombatDamage() && event.getAmount() > 0 && event.getAmount() < ojer.getPower().getValue();
    }
}

