/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardAndOrCardInLibrary;

class OjerKaslemDeepestGrowthEffect
extends OneShotEffect {
    OjerKaslemDeepestGrowthEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal that many cards from the top of your library. You may put a creature card and/or a land card from among them onto the battlefield. Put the rest on the bottom in a random order";
    }

    private OjerKaslemDeepestGrowthEffect(OjerKaslemDeepestGrowthEffect effect) {
        super((OneShotEffect)effect);
    }

    public OjerKaslemDeepestGrowthEffect copy() {
        return new OjerKaslemDeepestGrowthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = (Integer)this.getValue("damage");
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, xValue));
        if (!cards.isEmpty()) {
            controller.revealCards(source, (Cards)cards, game);
            TargetCardAndOrCardInLibrary target = new TargetCardAndOrCardInLibrary(CardType.CREATURE, CardType.LAND);
            controller.choose(Outcome.PutCardInPlay, (Cards)cards, (TargetCard)target, source, game);
            CardsImpl toBattlefield = new CardsImpl((Collection)target.getTargets());
            cards.removeAll((Collection)toBattlefield);
            controller.moveCards(toBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, false, false, false, null);
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }
}

