/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class OkoTheTricksterCopyEffect
extends OneShotEffect {
    OkoTheTricksterCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "Until end of turn, {this} becomes a copy of target creature you control";
    }

    private OkoTheTricksterCopyEffect(OkoTheTricksterCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public OkoTheTricksterCopyEffect copy() {
        return new OkoTheTricksterCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent == null || copyFromPermanent == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
        return true;
    }
}

