/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.cards.Card;
import mage.cards.o.OliviaCrimsonBrideAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class OliviaCrimsonBrideEffect
extends OneShotEffect {
    OliviaCrimsonBrideEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature card from your graveyard to the battlefield tapped and attacking. It gains \"When you don't control a legendary Vampire, exile this creature.\"";
    }

    private OliviaCrimsonBrideEffect(OliviaCrimsonBrideEffect effect) {
        super((OneShotEffect)effect);
    }

    public OliviaCrimsonBrideEffect copy() {
        return new OliviaCrimsonBrideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        game.getCombat().addAttackingCreature(permanent.getId(), game);
        game.addEffect(new GainAbilityTargetEffect((Ability)new OliviaCrimsonBrideAbility(), Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

