/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.SpellMasteryCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.GreatestPowerControlledPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class OlorinsSearingLightEffect
extends OneShotEffect {
    static FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature with the greatest power among creatures you control");

    public OlorinsSearingLightEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Each opponent exiles a creature with the greatest power among creatures that player controls.<br><i>Spell mastery</i> &mdash; If there are two or more instant and/or sorcery cards in your graveyard, {this} deals damage to each opponent equal to the power of the creature they exiled.";
    }

    private OlorinsSearingLightEffect(OlorinsSearingLightEffect effect) {
        super((OneShotEffect)effect);
    }

    public OlorinsSearingLightEffect copy() {
        return new OlorinsSearingLightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ArrayList<Permanent> toExile = new ArrayList<Permanent>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Permanent permanentChosen;
                Player player;
                if (!controller.hasOpponent(playerId, game) || (player = game.getPlayer(playerId)) == null) continue;
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (!player.choose(this.outcome, (Target)target, source, game) || (permanentChosen = game.getPermanent(target.getFirstTarget())) == null) continue;
                toExile.add(permanentChosen);
            }
            ArrayList<AbstractMap.SimpleImmutableEntry<Player, Integer>> damageList = new ArrayList<AbstractMap.SimpleImmutableEntry<Player, Integer>>();
            for (Permanent permanent : toExile) {
                Player opponent = game.getPlayer(permanent.getControllerId());
                if (opponent == null) continue;
                damageList.add(new AbstractMap.SimpleImmutableEntry<Player, Integer>(opponent, permanent.getPower().getValue()));
                opponent.moveCards((Card)permanent, Zone.EXILED, source, game);
            }
            if (SpellMasteryCondition.instance.apply(game, source)) {
                game.processAction();
                for (Map.Entry entry : damageList) {
                    ((Player)entry.getKey()).damage(((Integer)entry.getValue()).intValue(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)GreatestPowerControlledPredicate.instance);
    }
}

