/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OmnivorousFlytrapEffect
extends OneShotEffect {
    OmnivorousFlytrapEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the number of +1/+1 counters on those creatures";
    }

    private OmnivorousFlytrapEffect(OmnivorousFlytrapEffect effect) {
        super((OneShotEffect)effect);
    }

    public OmnivorousFlytrapEffect copy() {
        return new OmnivorousFlytrapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            int existingCounters;
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || (existingCounters = permanent.getCounters(game).getCount(CounterType.P1P1)) <= 0) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(existingCounters), source, game);
        }
        return true;
    }
}

