/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CanBeEnchantedByPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;
import mage.util.SubTypes;

class OneLastJobEffect
extends OneShotEffect {
    OneLastJobEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return target Aura or Equipment card from your graveyard to the battlefield attached to a creature you control";
    }

    private OneLastJobEffect(OneLastJobEffect effect) {
        super((OneShotEffect)effect);
    }

    public OneLastJobEffect copy() {
        return new OneLastJobEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card cardToReturn = game.getCard(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (cardToReturn == null || controller == null) {
            return false;
        }
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("a creature you control that " + cardToReturn.getLogName() + " can be attached to");
        filter.add((Predicate)new CanBeEnchantedByPredicate((MageObject)cardToReturn));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        controller.choose(Outcome.BoostCreature, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent != null) {
            game.informPlayers("Chosen creature to attach " + cardToReturn.getLogName() + " to:" + permanent.getLogName() + CardUtil.getSourceLogName((Game)game, (Ability)source));
            game.getState().setValue("attachTo:" + cardToReturn.getId(), (Object)permanent);
            controller.moveCards(cardToReturn, Zone.BATTLEFIELD, source, game);
            permanent.addAttachment(cardToReturn.getId(), source, game);
            return true;
        }
        SubTypes subTypes = cardToReturn.getSubtype(game);
        if (subTypes.contains((Object)SubType.AURA)) {
            game.informPlayers("No creatures controlled by " + controller.getLogName() + " to return " + cardToReturn.getLogName() + " attached to" + CardUtil.getSourceLogName((Game)game, (Ability)source));
            return true;
        }
        controller.moveCards(cardToReturn, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

