/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.o.OneWithTheMultiverseWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class OneWithTheMultiverseEffect
extends AsThoughEffectImpl {
    OneWithTheMultiverseEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.PlayForFree);
        this.staticText = "once during each of your turns, you may cast a spell from your hand or the top of your library without paying its mana cost.";
    }

    private OneWithTheMultiverseEffect(OneWithTheMultiverseEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public OneWithTheMultiverseEffect copy() {
        return new OneWithTheMultiverseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId) || !game.isActivePlayer(source.getControllerId())) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        Card card = game.getCard(CardUtil.getMainCardId((Game)game, (UUID)objectId));
        OneWithTheMultiverseWatcher watcher = (OneWithTheMultiverseWatcher)game.getState().getWatcher(OneWithTheMultiverseWatcher.class);
        if (controller == null || card == null || watcher == null || sourceObject == null || controller.getLibrary().getFromTop(game) == null || watcher.isAbilityUsed(new MageObjectReference((MageObject)sourceObject, game))) {
            return false;
        }
        Zone zone = game.getState().getZone(card.getId());
        if (!(Zone.HAND.match(zone) || Zone.LIBRARY.match(zone) && controller.getLibrary().getFromTop(game).getId().equals(card.getId()))) {
            return false;
        }
        this.allowCardToPlayWithoutMana(objectId, source, affectedControllerId, MageIdentifier.OneWithTheMultiverseWatcher, game);
        return true;
    }
}

