/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class OpenSeasonEffect
extends OneShotEffect {
    OpenSeasonEffect() {
        super(Outcome.LoseLife);
        this.staticText = "that creature's controller loses 2 life. Each other player gains 2 life";
    }

    private OpenSeasonEffect(OpenSeasonEffect effect) {
        super((OneShotEffect)effect);
    }

    public OpenSeasonEffect copy() {
        return new OpenSeasonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controller = game.getControllerId(source.getFirstTarget());
        if (controller != null) {
            game.getPlayer(controller).loseLife(2, game, source, false);
            for (UUID playerId : game.getOpponents(controller)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.gainLife(2, game, source);
            }
            return true;
        }
        return false;
    }
}

