/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OpenSeasonRestrictionEffect
extends RestrictionEffect {
    OpenSeasonRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures your opponent control with bounty counters on them can't activate abilities";
    }

    private OpenSeasonRestrictionEffect(OpenSeasonRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isCreature(game) && permanent.getCounters(game).getCount(CounterType.BOUNTY) > 0 && game.getOpponents(source.getControllerId()).contains(permanent.getControllerId());
    }

    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public OpenSeasonRestrictionEffect copy() {
        return new OpenSeasonRestrictionEffect(this);
    }
}

