/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.Graveyard;
import mage.players.Player;

class OpenTheVaultsEffect
extends OneShotEffect {
    OpenTheVaultsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return all artifact and enchantment cards from all graveyards to the battlefield under their owners' control";
    }

    private OpenTheVaultsEffect(OpenTheVaultsEffect effect) {
        super((OneShotEffect)effect);
    }

    public OpenTheVaultsEffect copy() {
        return new OpenTheVaultsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            LinkedHashSet<Card> cardsToReturn = new LinkedHashSet<Card>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                Graveyard graveyard = player.getGraveyard();
                for (UUID cardId : graveyard) {
                    Card card = game.getCard(cardId);
                    if (card == null || !card.isEnchantment(game) && !card.isArtifact(game)) continue;
                    cardsToReturn.add(card);
                }
            }
            controller.moveCards(cardsToReturn, Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }
}

