/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Iterator;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.o.OranRiefHydraEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OranRiefHydraTriggeredAbility
extends TriggeredAbilityImpl {
    private static final String text = "<i>Landfall</i> &mdash; Whenever a land you control enters, put a +1/+1 counter on {this}. If that land is a Forest, put two +1/+1 counters on {this} instead.";

    public OranRiefHydraTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new OranRiefHydraEffect());
    }

    private OranRiefHydraTriggeredAbility(OranRiefHydraTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public OranRiefHydraTriggeredAbility copy() {
        return new OranRiefHydraTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Iterator iterator;
        Permanent sourcePermanent;
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isLand(game) && permanent.isControlledBy(this.getControllerId()) && (sourcePermanent = game.getPermanent(this.getSourceId())) != null && (iterator = this.getEffects().iterator()).hasNext()) {
            Effect effect = (Effect)iterator.next();
            if (effect instanceof OranRiefHydraEffect) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return text;
    }
}

