/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class OriqLoremageEffect
extends OneShotEffect {
    OriqLoremageEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a card, put it into your graveyard, then shuffle. If it's an instant or sorcery card, put a +1/+1 counter on {this}";
    }

    private OriqLoremageEffect(OriqLoremageEffect effect) {
        super((OneShotEffect)effect);
    }

    public OriqLoremageEffect copy() {
        return new OriqLoremageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        if (card == null) {
            player.shuffleLibrary(source, game);
            return true;
        }
        player.moveCards(card, Zone.GRAVEYARD, source, game);
        player.shuffleLibrary(source, game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (!card.isInstantOrSorcery(game) || permanent == null) {
            return true;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        return true;
    }
}

