/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class OrphansOfTheWheatEffect
extends OneShotEffect {
    OrphansOfTheWheatEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap any number of untapped creatures you control. {this} gets +1/+1 until end of turn for each creature tapped this way";
    }

    private OrphansOfTheWheatEffect(OrphansOfTheWheatEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrphansOfTheWheatEffect copy() {
        return new OrphansOfTheWheatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURES, true);
        player.choose(Outcome.Tap, (Target)target, source, game);
        List permanents = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        for (Permanent permanent : permanents) {
            permanent.tap(source, game);
        }
        if (permanents.isEmpty()) {
            return false;
        }
        int amount = permanents.size();
        game.addEffect((ContinuousEffect)new BoostSourceEffect(amount, amount, Duration.EndOfTurn), source);
        return true;
    }
}

