/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class OutOfTheTombsReplacementEffect
extends ReplacementEffectImpl {
    OutOfTheTombsReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card while your library has no cards in it, instead return a creature card from your graveyard to the battlefield. If you can't, you lose the game.";
    }

    private OutOfTheTombsReplacementEffect(OutOfTheTombsReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public OutOfTheTombsReplacementEffect copy() {
        return new OutOfTheTombsReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        Player player = game.getPlayer(event.getPlayerId());
        if (player == null) {
            return false;
        }
        boolean cardReturned = false;
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        if (target.canChoose(player.getId(), source, game) && target.choose(Outcome.PutCreatureInPlay, player.getId(), source.getSourceId(), source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
            cardReturned = true;
        }
        if (!cardReturned) {
            game.informPlayers(player.getLogName() + " can't return a card from graveyard to hand.");
            player.lost(game);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getPlayerId().equals(source.getControllerId())) {
            Player player = game.getPlayer(event.getPlayerId());
            return player != null && !player.hasLost() && !player.getLibrary().hasCards();
        }
        return false;
    }
}

